local curScreen = Var "LoadingScreen";
local curStage = GAMESTATE:GetCurrentStage();
local curStageIndex = GAMESTATE:GetCurrentStageIndex();
local t = Def.ActorFrame {};

t[#t+1] = Def.ActorFrame {
	LoadFont("_g7 star force ttf 20px") .. {
		InitCommand=cmd(y,-1;shadowlength,1;);
		BeginCommand=function(self)
			local top = SCREENMAN:GetTopScreen()
			if top then
				if not string.find(top:GetName(),"ScreenEvaluation") then
					curStageIndex = curStageIndex + 1
				end
			end
			self:playcommand("Set")
		end;
		SetCommand=function(self)
			if GAMESTATE:GetCurrentCourse() then
				self:settext( curStageIndex+1 .. " / " .. GAMESTATE:GetCurrentCourse():GetEstimatedNumStages() );
			elseif GAMESTATE:IsEventMode() then
				self:settextf("STAGE %s", curStageIndex);
			else
				if THEME:GetMetric(curScreen,"StageDisplayUseShortString") then
				  self:settextf("%s", ToEnumShortString(string.upper(curStage)));
				  self:zoom(1);
				else
				  	if GAMESTATE:IsExtraStage() then
						self:settext("EXTRA STAGE");
						self:textglowmode('TextGlowMode_Inner');
						self:glowshift();
					elseif GAMESTATE:IsExtraStage2() then
						self:settext("ANOTHER STAGE")
						self:textglowmode('TextGlowMode_Inner');
						self:glowshift();
					else
						self:settextf("%s STAGE", ToEnumShortString(string.upper(curStage)));
					end;
					self:zoom(1);
				end;
			end;
			-- StepMania is being stupid so we have to do this here;
			self:diffuse(StageToColor(curStage));
			self:diffusetopedge(ColorLightTone(StageToColor(curStage)));
			self:strokecolor(ColorDarkTone(StageToColor(curStage)));
		end;
	};
};
return t